import request from "@/utils/request";
export function fetchList(params) {
  return request({
    url: "/product/list",
    method: "get",
    params: params
  });
}

export function fetchSimpleList(params) {
  return request({
    url: "/product/simpleList",
    method: "get",
    params: params
  });
}

export function updateDeleteStatus(params) {
  return request({
    url: "/product/update/deleteStatus",
    method: "post",
    params: params
  });
}

export function updateNewStatus(params) {
  return request({
    url: "/product/update/newStatus",
    method: "post",
    params: params
  });
}



export function noticeAll(data) {
  // 学服部主管-系统公告-分页查询系统公告
  return request({
    url: `/system/notice/all`,
    method: "post",
    data
  });
}

export function addNoticeAll(data) {
  // 学服部主管-系统公告-添加系统公告
  return request({
    url: `/system/notice/add`,
    method: "post",
    data
  });
}

export function deleteNotice(id) {
  // 学服部主管-系统公告-删除系统公告
  return request({
    url: `/system/notice/delete/${id}`,
    method: "post"
  });
}
export function updateNoticeAll(data) {
  // 学服部主管-系统公告-修改系统公告
  return request({
    url: `/system/notice/update`,
    method: "post",
    data
  });
}

export function xuefuMasterAllStu(data) {
  // 学服部主管-全部学员
  return request({
    url: `/course/filter/all`,
    method: "post",
    data
  });
}

export function school(data) {
  // 学服部主管-全部学员-学校列表
  return request({
    url: `/filter/param/school`,
    method: "post",
    data
  });
}
export function courseTime(data) {
  // 学服部主管-全部学员-报名学期列表
  return request({
    url: `/filter/param/courseTime`,
    method: "post",
    data
  });
}

export function selectCourse(state, data) {
  // 今日任务-审课待分配-根据条件查询(待确认/审课中、审课通过/审课未通过)课程信息
  return request({
    url: `/course/filter/list/selectCourse/${state}`,
    method: "post",
    data
  });
}

export function confirmCourse(data) {
  // 今日任务-审课待分配-确认课程
  return request({
    url: `/course/filter/confirmCourse`,
    method: "post",
    data
  });
}

export function LOPState(data) {
  // 今日任务-审课待分配-LOP确认
  return request({
    url: `/course/filter/LOPState`,
    method: "post",
    data
  });
}




export function errorWord(data) {
  // 单词报错查询接口
  return request({
    url: `/error/word`,
    method: "post",
    data
  });
}

export function baseWordRedisData(data) {
  // 单词缓存
  return request({
    url: `/complex/font/baseWordRedisData`,
    method: "post",
    data
  });
}

export function getPageBaseWord(data) {
  // 单词分页查询
  return request({
    url: `/baseWord/getPageBaseWord`,
    method: "post",
    data
  });
}

export function getBaseWordById(id) {
  // 获取单词基础信息信息
  return request({
    url: `/baseWord/getBaseWordById/${id}`,
    method: "post"
  });
}

export function updateByPrimaryKeySelective(data) {
  // 修改单词基础信息
  return request({
    url: `/baseWord/updateByPrimaryKeySelective`,
    method: "post",
    data
  });
}

export function getPageGradeWord(data) {
  // 简体词库信息分页查询
  return request({
    url: `/gradeWord/getPageGradeWord`,
    method: "post",
    data
  });
}

export function gradeWordHansRedisData(data) {
  // 简体词库释义缓存
  return request({
    url: `/complex/font/gradeWordHansRedisData`,
    method: "post",
    data
  });
}

export function getGradeWordById(id) {
  // 获取简体词库信息信息
  return request({
    url: `/gradeWord/getGradeWordById/${id}`,
    method: "post"
  });
}

export function updateByPrimaryKeySelectiveGrade(data) {
  // 修改简体词库信息
  return request({
    url: `/gradeWord/updateByPrimaryKeySelective`,
    method: "post",
    data
  });
}

export function addGradeWord(data) {
  // 增加简体词库信息
  return request({
    url: `/gradeWord/add`,
    method: "post",
    data
  });
}


export function getPageRootAffix(data) {
  // 词根词缀分页查询
  return request({
    url: `/rootAffix/getPageRootAffix`,
    method: "post",
    data
  });
}

export function getRootAffixById(id) {
  // 获取词根词缀信息
  return request({
    url: `/rootAffix/getRootAffixById/${id}`,
    method: "post"
  });
}

export function updateByPrimaryKeySelectiveRootAffix(data) {
  // 修改词根词缀
  return request({
    url: `/rootAffix/updateByPrimaryKeySelective`,
    method: "post",
    data
  });
}

export function insertSelectiveRootAffix(data) {
  // 添加词根词缀
  return request({
    url: `/rootAffix/insertSelective`,
    method: "post",
    data
  });
}

export function deleteByPrimaryKeyRootAffix(id) {
  // 删除词根词缀
  return request({
    url: `/rootAffix/deleteByPrimaryKey/${id}`,
    method: "post"
  });
}

export function getPageTextbookWord(data) {
  // 词书单词信息分页查询
  return request({
    url: `/textbookWord/getPageTextbookWord`,
    method: "post",
    data
  });
}

export function getTextbookWordById(id) {
  // 获取词根词缀信息
  return request({
    url: `/textbookWord/getTextbookWordById/${id}`,
    method: "post"
  });
}

export function updateByPrimaryKeySelectiveTextbookWord(data) {
  // 修改词书单词信息
  return request({
    url: `/textbookWord/updateByPrimaryKeySelective`,
    method: "post",
    data
  });
}

export function getPageTextbookWordError(data) {
  // 错误单词信息分页查询
  return request({
    url: `/baseWord/getPageTextbookWord`,
    method: "post",
    data
  });
}

export function baseWordUpdate(data) {
  // 错误单词信息已完成按钮
  return request({
    url: `/baseWord/update`,
    method: "post",
    data
  });
}

export function getPageBaseWordMission(data) {
  // 任务信息分页查询
  return request({
    url: `/mission/getPageBaseWord`,
    method: "post",
    data
  });
}

export function getBaseWordByIdMission(id) {
  // 获取任务信息信息
  return request({
    url: `/mission/getBaseWordById/${id}`,
    method: "post"
  });
}

export function updateByPrimaryKeySelectiveMission(data) {
  // 修改任务信息
  return request({
    url: `/mission/updateByPrimaryKeySelective`,
    method: "post",
    data
  });
}

export function getPageFurnitureInfo(data) {
  // 家具信息分页查询
  return request({
    url: `/furniture/getPageFurnitureInfo`,
    method: "post",
    data
  });
}

export function getFurnitureInfoById(id) {
  // 获取家具信息信息
  return request({
    url: `/furniture/getFurnitureInfoById/${id}`,
    method: "post"
  });
}

export function updateByPrimaryKeySelectiveFurniture(data) {
  // 修改家具信息
  return request({
    url: `/furniture/updateByPrimaryKeySelective`,
    method: "post",
    data
  });
}

export function insertSelectiveFurniture(data) {
  // 添加家具信息
  return request({
    url: `/furniture/insertSelective`,
    method: "post",
    data
  });
}

export function getPageResourceStore(data) {
  // 熊猫币商城信息分页查询
  return request({
    url: `/resource/store/getPageResourceStore`,
    method: "post",
    data
  });
}

export function getResourceStoreById(id) {
  // 获取熊猫币商城信息
  return request({
    url: `/resource/store/getResourceStoreById/${id}`,
    method: "post"
  });
}

export function updateByPrimaryKeySelectiveResourceStore(data) {
  // 修改熊猫币商城信息
  return request({
    url: `/resource/store/updateByPrimaryKeySelective`,
    method: "post",
    data
  });
}

export function insertSelectiveResourceStore(data) {
  // 添加熊猫币商城信息
  return request({
    url: `/resource/store/insertSelective`,
    method: "post",
    data
  });
}

export function deleteByPrimaryKeyResourceStore(id) {
  // 删除熊猫币商城信息
  return request({
    url: `/resource/store/deleteByPrimaryKey/${id}`,
    method: "post"
  });
}

export function getPageRmbStore(data) {
  // 人民币商城信息分页查询
  return request({
    url: `/rmbStore/getPageRmbStore`,
    method: "post",
    data
  });
}

export function getRmbStoreById(id) {
  // 获取人民币商城信息
  return request({
    url: `/rmbStore/getRmbStoreById/${id}`,
    method: "post"
  });
}

export function updateByPrimaryKeySelectiveRmbStore(data) {
  // 修改人民币商城信息
  return request({
    url: `/rmbStore/updateByPrimaryKeySelective`,
    method: "post",
    data
  });
}

export function insertSelectiveRmbStore(data) {
  // 添加人民币商城信息
  return request({
    url: `/rmbStore/insertSelective`,
    method: "post",
    data
  });
}

export function deleteByPrimaryKeyRmbStore(id) {
  // 删除人民币商城信息
  return request({
    url: `/rmbStore/deleteByPrimaryKey/${id}`,
    method: "post"
  });
}

export function getRmbStoreResource(rmbStoreId) {
  // 人民币商城资源信息分页查询
  return request({
    url: `/rmbStoreResource/getRmbStoreResource/${rmbStoreId}`,
    method: "post"
  });
}

export function getRmbStoreResourceById(id) {
  // 获取人民币商城资源信息
  return request({
    url: `/rmbStoreResource/getRmbStoreResourceById/${id}`,
    method: "post"
  });
}

export function updateByPrimaryKeySelectiveRmbStoreResource(data) {
  // 修改人民币商城资源信息
  return request({
    url: `/rmbStoreResource/updateByPrimaryKeySelective`,
    method: "post",
    data
  });
}

export function insertSelectiveRmbStoreResource(data) {
  // 添加人民币商城资源信息
  return request({
    url: `/rmbStoreResource/insertSelective`,
    method: "post",
    data
  });
}

export function deleteByPrimaryKeyRmbStoreResource(id) {
  // 删除人民币商城资源信息
  return request({
    url: `/rmbStoreResource/deleteByPrimaryKey/${id}`,
    method: "post"
  });
}

export function getInviteAwardById(data) {
  // 获取邀请奖励信息信息
  return request({
    url: `/inviteAward/getInviteAwardById`,
    method: "post",
    data
  });
}

export function updateByPrimaryKeySelectiveInviteAward(data) {
  // 修改邀请奖励信息
  return request({
    url: `/inviteAward/updateByPrimaryKeySelective`,
    method: "post",
    data
  });
}

export function getAdvertiseNumById(data) {
  // 获取每日广告限制信息
  return request({
    url: `/advertiseNum/getAdvertiseNumById`,
    method: "post",
    data
  });
}

export function updateByPrimaryKeySelectiveAdvertiseNum(data) {
  // 修改每日广告限制
  return request({
    url: `/advertiseNum/updateByPrimaryKeySelective`,
    method: "post",
    data
  });
}

export function getPageFurnitureInfoLottery(data) {
  // 抽奖概率信息分页查询
  return request({
    url: `/lottery/getPageFurnitureInfo`,
    method: "post",
    data
  });
}

export function allLottery(data) {
  // 全部稀有度信息
  return request({
    url: `/lottery/all`,
    method: "post",
    data
  });
}

export function getLotteryById(id) {
  // 获取抽奖概率信息;
  return request({
    url: `/lottery/getLotteryById/${id}`,
    method: "post"
  });
}

export function updateByPrimaryKeySelectiveLottery(data) {
  // 修改抽奖概率信息
  return request({
    url: `/lottery/updateByPrimaryKeySelective`,
    method: "post",
    data
  });
}

export function getPageFurnitureInfoAchievement(data) {
  // 勋章信息分页查询
  return request({
    url: `/achievement/getPageFurnitureInfo`,
    method: "post",
    data
  });
}

export function getAchievementInfoById(id) {
  // 获取勋章信息;
  return request({
    url: `/achievement/getAchievementInfoById/${id}`,
    method: "post"
  });
}

export function updateByPrimaryKeySelectiveAchievement(data) {
  // 修改勋章信息
  return request({
    url: `/achievement/updateByPrimaryKeySelective`,
    method: "post",
    data
  });
}

//伙伴管理模块
export function getFriendsList(data) {
  // 获取伙伴信息列表
  return request({
    url: `/mashup/dragon/internal/api/definition/page`,
    method: "post",
    data
  });
}

export function updateFriends(data) {
  // 增加和修改改伙伴信息
  return request({
    url: `/mashup/dragon/internal/api/definition/save`,
    method: "post",
    data
  });
}

export function firstDialogue(data) {
  // 生成伙伴初次对话
  return request({
    url: `/mashup/dragon/internal/api/dialogue/material/generate`,
    method: "post",
    data
  });
}

export function getfirstDialogue(data) {
  // 获取伙伴初次对话
  return request({
    url: `/mashup/dragon/internal/api/dialogue/material/page`,
    method: "post",
    data
  });
}
export function updateDialogue(data) {
  // 更新对话数据
  return request({
    url: `/mashup/dragon/internal/api/dialogue/material/update`,
    method: "post",
    data
  });
}
export function deleteDialogue(data) {
  // 删除对话数据
  return request({
    url: `/mashup/dragon/internal/api/dialogue/material/delete`,
    method: "post",
    data
  });
}
export function getFinDialogue(data) {
  // 翻译、转换对话数据
  return request({
    url: `/mashup/dragon/internal/api/dialogue/material/transition`,
    method: "post",
    data
  });
}
export function saveDialogue(data) {
  // 保存对话数据
  return request({
    url: `/mashup/dragon/internal/api/dialogue/material/synchronize`,
    method: "post",
    data
  });
}


//邮箱模块
export function updateMail(data) {
  // 新增/修改邮件
  return request({
    url: `/mashup/mail/internal/api/save`,
    method: "post",
    data
  });
}
export function getMailList(data) {
  // 邮件分页列表
  return request({
    url: `/mashup/mail/internal/api/page`,
    method: "post",
    data
  });
}

export function deleteMail(data) {
  // 删除邮件
  return request({
    url: `/mashup/mail/internal/api/delete`,
    method: "post",
    data
  });
}