
const { ccclass, property } = cc._decorator;

class FaceData {
    public name: string;
    public bodyInd: string;
    public faceInd: string;
    public hairInd: string;
    public kitInd: string;
}
class Root {
    public faceDataLists: FaceData[];
}
@ccclass
export default class RandRole extends cc.Component {
    @property(cc.Sprite)
    public cbody: cc.Sprite;
    @property(cc.Sprite)
    public cface: cc.Sprite;
    @property(cc.Sprite)
    public chair: cc.Sprite;
    @property(cc.Sprite)
    public ckit: cc.Sprite;
    @property([cc.SpriteFrame])
    public body: cc.SpriteFrame[] = [];
    @property([cc.SpriteFrame])
    public face: cc.SpriteFrame[] = [];
    @property([cc.SpriteFrame])
    public hair: cc.SpriteFrame[] = [];
    @property([cc.SpriteFrame])
    public kit: cc.SpriteFrame[] = [];
    @property([cc.Color])
    public background: cc.Color[];
    public static faceDataLists: FaceData[];
    public faceDatas: string[][];

    public static getJsonInfo() {

    }
    
    public changeRole(name: string) {
        let bodyind = -1, faceind = -1, hairind = -1, kitind = -1;
        RandRole.faceDataLists.forEach((data) => {
            if (data.name == name) {
                bodyind = parseInt(data.bodyInd);
                faceind = parseInt(data.faceInd);
                hairind = parseInt(data.hairInd);
                kitind = parseInt(data.kitInd);
            }
        })

        this.cbody.spriteFrame = this.body[bodyind];
        this.cface.spriteFrame = this.face[faceind];
        this.chair.spriteFrame = this.hair[hairind];
        this.ckit.spriteFrame = this.kit[kitind];
    }
    public randomizeCharacter() {
        const random1: number = Math.floor(Math.random() * this.body.length);
        const random2: number = Math.floor(Math.random() * this.face.length);
        const random3: number = Math.floor(Math.random() * this.hair.length);
        const random4: number = Math.floor(Math.random() * this.kit.length);

        this.cbody.spriteFrame = this.body[random1];
        this.cface.spriteFrame = this.face[random2];
        this.chair.spriteFrame = this.hair[random3];
        this.ckit.spriteFrame = this.kit[random4];
        console.log(random1 + "  " + random2 + "  " + random3 + "  " + random4);
    }
}
