
function testable(isTestable) {
    return function (target) {
        target.isTestable = isTestable;
    }
}
function log(target, name, descriptor) {
    var oldValue = descriptor.value;

    descriptor.value = function () {
        console.log(`Calling ${name} with`, arguments);
        return oldValue.apply(this, arguments);
    };

    return descriptor;
}
function mixins(...list) {
    return function (target) {
        Object.assign(target.prototype, ...list)
    }
}
function nonenumerable(target, name, descriptor) {
    descriptor.enumerable = false;
    return descriptor;
}
function readonly(target, name, descriptor) {
    descriptor.writable = false;
    return descriptor;
}

export { testable, log, mixins, nonenumerable, readonly }