let { AwardManager, ComboManager } = require('FreeCollection')

cc.Class({
    extends: cc.Component,

    properties: {
        awardEffectPre: cc.Prefab,
        comboEffectPre: cc.Prefab,
        soundFxPre: cc.Prefab,
        awardManager: null,
        comboManager: null,
        newFunc: null,
        add: null
    },

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {},
    start() {

    },
    init() {
        let award = cc.instantiate(this.awardEffectPre);
        this.node.addChild(award);
        let awardControl = award.getComponent("FreeAwardEffect");
        this.awardManager = new AwardManager(awardControl);

        let combo = cc.instantiate(this.comboEffectPre);
        this.node.addChild(combo);
        let comboControl = combo.getComponent("FreeComboEffect");
        this.comboManager = new ComboManager(comboControl);
    },
    //设置奖励文字与Combo计数的关系，args为多个参数
    setAward(data) {
        this.awardManager.addAward(data);
        this.comboManager.setAwardManager(this.awardManager);
    },
    //combo叠加一层
    comboAdd() {
        this.comboManager.comboAdd();
    },
    //combo懒叠加，如果用户使用懒叠加，则在一帧内，最多只叠加一层
    comboAddLazy() {
        if (this.comboManager.isAllowLazyAdd) {
            this.comboManager.isAllowLazyAdd = false;
            this.comboManager.comboAdd();
        }
        //else console.log("----由于懒叠加，combo并没有继续触发" + "----");
    },
    //打断combo的函数
    comboBreak() {
        this.comboManager.comboBreak();
    },
    //重置的函数
    reset() {
        this.comboManager.reset();
        this.awardManager.reset();
    },
    // update (dt) {},
    lateUpdate(dt) {
        this.comboManager.isAllowLazyAdd = true;
    }
});
