// Learn cc.Class:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] https://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        mySprite: cc.Sprite,
        playFxPrefab: cc.Prefab,
        spriteList: [cc.SpriteFrame],
        tween: null,

    },

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {},

    start() {
        this.doClose();
    },
    doActive() {
        this.node.active = true;
    },
    doClose() {
        this.node.active = false;
        this.reset();
    },
    reset() {
        if (this.tween) {
            this.tween.stop();
            this.tween = null;
        }
        this.node.scale = 0;
        this.node.position = cc.v2(0, 150);
    },
    showCombo(num) {
        if (num > this.spriteList.length) return;
        if (this.node.active) this.reset();
        else this.doActive();

        this.playFx(num);
        this.mySprite.spriteFrame = this.spriteList[num - 1];
        this.tween = cc.tween(this.node)
            .by(0.4, { scale: 1.2, position: cc.v2(0, 150) }, { easing: 'backOut' })
            .by(0.8, { scale: 0, position: cc.v2(0, 0) })
            .to(0.4, { scale: 0, position: cc.v2(0, 300) }, { easing: 'backIn' })
            .call(() => {
                //console.log('combo动画效果');
                this.doClose();
            })
            .start();


    },
    playFx(num) {
        let playFxPrefab = cc.instantiate(this.playFxPrefab);
        this.node.addChild(playFxPrefab);
        playFxPrefab.getComponent('FreeSoundFx').playComboFx(num);
    },
    // update (dt) {},
});
