cc.Class({
    extends: cc.Component,

    properties: {
        audioSource: cc.AudioSource,
        comboSoundFx: [cc.AudioClip],
        awardSoundFx: [cc.AudioClip],
        isPlay: false,
    },

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {},

    start() {

    },

    playComboFx(num) {
        this.playFx(0, num);
    },
    playAwardFx(num) {
        this.playFx(1, num);
    },
    playFx(type, num) {
        let clip = null;
        if (type == 0) {
            clip = this.comboSoundFx[(num - 1)%this.comboSoundFx.length];
        } else {
            clip = this.awardSoundFx[(num - 1)%this.awardSoundFx.length]; 
        }

        this.audioSource.clip = clip;
        this.isPlay = true;
        this.audioSource.play();
    },

    update(dt) {
        if (this.isPlay == false) return;
        if (!this.audioSource.isPlaying) {
            this.node.destroy();
            // console.log('PhreeSoundFx已销毁');
        }
    },
});
