// Learn cc.Class:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] https://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        spriteList: [cc.SpriteFrame],
        mySprite:cc.Sprite,
        playFxPrefab: cc.Prefab,
        tween:null
    },

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {},

    start() {
        this.doClose();
    },
    doActive() {
        this.node.active = true;
    },
    doClose() {
        this.node.active = false;
        this.reset();
    },
    reset() {
        if (this.tween) {
            this.tween.stop();
            this.tween = null;
        }
        this.node.scale = 0;
        this.node.pacity = 255;
    },
    showAward(index) {
        if (index > this.spriteList.length-1) return;
        if (this.node.active) this.reset();
        else this.doActive();

        this.playFx(index+1);
        this.mySprite.spriteFrame = this.spriteList[index];
        this.tween = cc.tween(this.node)
            .by(0.4, { scale: 1.2, position: cc.v2(0, 0) }, { easing: 'backOut' })
            .by(0.8, { scale: 0, position: cc.v2(0, 0) })
            .to(0.4, { scale: 0 }, { easing: 'backIn' })
            .call(() => {
                //console.log('award动画效果');
                this.doClose();
            })
            .start();
    },
    playFx(num) {
        let playFxPrefab = cc.instantiate(this.playFxPrefab);
        this.node.addChild(playFxPrefab);
        playFxPrefab.getComponent('FreeSoundFx').playAwardFx(num);
    },
    // update (dt) {},
});
