let { AwardManager, ComboManager, FxManager } = require('FreeCollection')

cc.Class({
    extends: cc.Component,

    properties: {
        awardEffectPre: cc.Prefab,
        comboEffectPre: cc.Prefab,
        soundFxPre: cc.Prefab,
        awardManager: null,
        comboManager: null,
        newFunc: null,
        add: null
    },

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {},
    start() {

    },
    init() {
        //初始化音频管理类
        let fxGroup = [];
        for(let i = 0; i < 3; i++){
            let fx = cc.instantiate(this.soundFxPre);
            this.node.addChild(fx);
            fxGroup.push(fx.getComponent("FreeSoundFx"));
        }
        this.fxManager = new FxManager(fxGroup);
        //初始化奖励管理类
        let award = cc.instantiate(this.awardEffectPre);
        this.node.addChild(award);
        let awardControl = award.getComponent("FreeAwardEffect");
        awardControl.fxManager = this.fxManager;
        this.awardManager = new AwardManager(awardControl);
        //初始化combo管理类
        let combo = cc.instantiate(this.comboEffectPre);
        this.node.addChild(combo);
        let comboControl = combo.getComponent("FreeComboEffect");
        comboControl.fxManager = this.fxManager;
        this.comboManager = new ComboManager(comboControl);

    },
    //设置奖励文字与Combo计数的关系，args为多个参数
    setAward(data) {
        this.awardManager.addAward(data);
        this.comboManager.setAwardManager(this.awardManager);
    },
    //combo叠加一层
    comboAdd() {
        this.comboManager.comboAdd();
    },
    //combo懒叠加，如果用户使用懒叠加，则在一帧内，最多只叠加一层
    comboAddLazy() {
        if (this.comboManager.isAllowLazyAdd) {
            this.comboManager.isAllowLazyAdd = false;
            this.comboManager.comboAdd();
        }
        //else console.log("----由于懒叠加，combo并没有继续触发" + "----");
    },
    //打断combo的函数
    comboBreak() {
        this.comboManager.comboBreak();
    },
    //重置的函数
    reset() {
        this.comboManager.reset();
        this.awardManager.reset();
    },
    // update (dt) {},
    lateUpdate(dt) {
        this.comboManager.isAllowLazyAdd = true;
    }
});
