/**
 * 找到场景里任意节点
 * @param node 给定某一场景里任意节点
 * @param name 要寻找的节点名
 * @param isBfs true为广度优先，false为深度优先
 * @returns node or false
 */
//找到根节点
function findNode(node, name, {isBfs = true}={}) {
    if (node.parent)
        return findNode(node.parent, name, isBfs);
    else
        return isBfs ? bfs(node, name) : dfs(node, name);
}
//广度优先搜索
function bfs(node, name) {
    if (node != null) {
        var queue = [];
        queue.unshift(node);
        while (queue.length != 0) {
            var item = queue.shift();
            // console.log("item",item.name)
            if (item.name.toString() == name)
                return item;
            var children = item.children;
            for (var i = 0; i < children.length; i++)
                queue.push(children[i]);
        }
    }
    return false;
}
//深度优先搜索
function dfs(node, name) {
    if (node != null) {
        var stack = [];
        stack.push(node);
        while (stack.length != 0) {
            var item = stack.pop();
            if (item.name.toString() == name)
                return item;
            var children = item.children;
            for (var i = children.length - 1; i >= 0; i--)
                stack.push(children[i]);
        }
    }
    return false;
}
let freeCombo = {

    comboManager: undefined,
    //在当前场景的Canvas中找到ComboManager预置体，实现对ComboManager的控制
    init(node) {
        let comboManagerNode = findNode(node, "ComboManager");
        if (comboManagerNode)
            console.log("找到Combo管理器");
        else
            console.log("未成功找到Combo管理器，请检查是否在场景中挂载ComboManager预制体");
        this.comboManager = comboManagerNode.getComponent("ComboManager");
        this.comboManager.init();
    },
    //设置奖励文字与Combo计数的关系，data：[3,5]
    setAward(...data) {
        this.comboManager.setAward(data);
    },
    //combo叠加一层
    comboAdd() {
        this.comboManager.comboAdd();
    },
    //combo懒叠加，如果用户使用懒叠加，则在一帧内，最多只叠加一层
    comboAddLazy() {
        this.comboManager.comboAddLazy();
    },
    //打断combo的函数
    comboBreak() {
        this.comboManager.comboBreak();
    },
    //重置的函数
    reset() {
        this.comboManager.reset();
    },
};

module.exports = freeCombo;