class AwardManager {
    constructor(award) {
        this.awardList = [];
        this.award = award;
    }

    addAward(data) {
        if (data.length > this.award.spriteList.length) {
            console.warn("当前只设置了" + this.award.spriteList.length + "张奖励图片，但提供了" + data.length + "个奖励位置,多出的奖励将不会显示");
            data = data.slice(0, this.award.spriteList.length);
        }
        this.awardList = data;
    }
    checkAward(num) {
        let index = 0;
        this.awardList.forEach((item) => {
            if (item == num) {
                this.award.showAward(index);
                ///
                //console.log("----" + "combo数为" + num + "时，第" + (index+1) + "个award出现" + "----")
            }
            index++;
        })
    }
    reset() {
        ///
        //console.log("awardManager恢复初始状态");
        this.award.reset();
    }
    log() {
        console.log("awardList", this.awardList);
    }
}
class ComboManager {
    constructor(combo) {
        this.comboCacul = 0;
        this.combo = combo;
        this.isAllowLazyAdd = true;
        this.awardManager = null;
    }
    setAwardManager(manager) {
        this.awardManager = manager;
    }
    comboAdd() {
        this.comboCacul++;
        if (this.comboCacul > 1 && this.awardManager) this.awardManager.checkAward(this.comboCacul - 1);
        if (this.comboCacul > 1) this.combo.showCombo(this.comboCacul - 1);
        ///
        //console.log("----" + "combo*" + this.comboCacul + "出现了----")
    }
    comboBreak() {
        this.comboCacul = 0;
        ///
        //console.log("----combo被打断了，重置为0----")
    }
    reset() {
        this.comboCacul = 0;
        this.combo.reset();
        //console.log("comboManager恢复初始状态");
    }
    log() {
        console.log("combo", this.combo);
    }
}
class FxManager {
    constructor(group) {
        this.fxGroup = group;
        try {
            this.preReadyFx = this.fxGroup[0];
        } catch (e) {
            console.log("FxManager构造函数报错");
            console.error(e);
        }
    }
    playAwardFx(num) {
        let fx = this.getOneFx();
        fx.playAwardFx(num);
    }
    playComboFx(num) {
        let fx = this.getOneFx();
        fx.playComboFx(num);
    }
    getOneFx() {
        let readyFx = this.fxGroup.shift();
        this.fxGroup.push(readyFx);
        return readyFx;
    }
}
export default { AwardManager, ComboManager, FxManager }