package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.AuthorTimeItem;
import com.panda.zgqc.app.service.IAuthorTimeItemService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/author/time/item")
public class AuthorTimeItemController {
    @Autowired
    private IAuthorTimeItemService authorTimeItemService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, AuthorTimeItem authorTimeItem) {
        return AjaxResult.success(authorTimeItemService.page(pageEntity.toPage(), Wrappers.lambdaQuery(authorTimeItem)));
    }

    @GetMapping("/list")
    public AjaxResult list(AuthorTimeItem authorTimeItem) {
        return AjaxResult.success(authorTimeItemService.list(Wrappers.lambdaQuery(authorTimeItem)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody AuthorTimeItem authorTimeItem) {
        return AjaxResult.success(authorTimeItemService.save(authorTimeItem));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody AuthorTimeItem authorTimeItem) {
        return AjaxResult.success(authorTimeItemService.updateById(authorTimeItem));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(authorTimeItemService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(authorTimeItemService.getById(id));
    }
}
