package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.BrandEntityShow;
import com.panda.zgqc.app.service.IBrandEntityShowService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/brand/entity/show")
public class BrandEntityShowController {
    @Autowired
    private IBrandEntityShowService brandEntityShowService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, BrandEntityShow brandEntityShow) {
        return AjaxResult.success(brandEntityShowService.page(pageEntity.toPage(), Wrappers.lambdaQuery(brandEntityShow)));
    }

    @GetMapping("/list")
    public AjaxResult list(BrandEntityShow brandEntityShow) {
        return AjaxResult.success(brandEntityShowService.list(Wrappers.lambdaQuery(brandEntityShow)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody BrandEntityShow brandEntityShow) {
        return AjaxResult.success(brandEntityShowService.save(brandEntityShow));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody BrandEntityShow brandEntityShow) {
        return AjaxResult.success(brandEntityShowService.updateById(brandEntityShow));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(brandEntityShowService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(brandEntityShowService.getById(id));
    }
}
