package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.BrandInformation;
import com.panda.zgqc.app.service.IBrandInformationService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/brand/information")
public class BrandInformationController {
    @Autowired
    private IBrandInformationService brandInformationService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, BrandInformation brandInformation) {
        return AjaxResult.success(brandInformationService.page(pageEntity.toPage(), Wrappers.lambdaQuery(brandInformation)));
    }

    @GetMapping("/list")
    public AjaxResult list(BrandInformation brandInformation) {
        return AjaxResult.success(brandInformationService.list(Wrappers.lambdaQuery(brandInformation)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody BrandInformation brandInformation) {
        return AjaxResult.success(brandInformationService.save(brandInformation));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody BrandInformation brandInformation) {
        return AjaxResult.success(brandInformationService.updateById(brandInformation));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(brandInformationService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(brandInformationService.getById(id));
    }
}
