package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.DiseasePesstore;
import com.panda.zgqc.app.service.IDiseasePesstoreService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/disease/pesstore")
public class DiseasePesstoreController {
    @Autowired
    private IDiseasePesstoreService diseasePesstoreService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, DiseasePesstore diseasePesstore) {
        return AjaxResult.success(diseasePesstoreService.page(pageEntity.toPage(), Wrappers.lambdaQuery(diseasePesstore)));
    }

    @GetMapping("/list")
    public AjaxResult list(DiseasePesstore diseasePesstore) {
        return AjaxResult.success(diseasePesstoreService.list(Wrappers.lambdaQuery(diseasePesstore)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody DiseasePesstore diseasePesstore) {
        return AjaxResult.success(diseasePesstoreService.save(diseasePesstore));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody DiseasePesstore diseasePesstore) {
        return AjaxResult.success(diseasePesstoreService.updateById(diseasePesstore));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(diseasePesstoreService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(diseasePesstoreService.getById(id));
    }
}
