package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.InsuranceProduct;
import com.panda.zgqc.app.service.IInsuranceProductService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/insurance/product")
public class InsuranceProductController {
    @Autowired
    private IInsuranceProductService insuranceProductService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, InsuranceProduct insuranceProduct) {
        return AjaxResult.success(insuranceProductService.page(pageEntity.toPage(), Wrappers.lambdaQuery(insuranceProduct)));
    }

    @GetMapping("/list")
    public AjaxResult list(InsuranceProduct insuranceProduct) {
        return AjaxResult.success(insuranceProductService.list(Wrappers.lambdaQuery(insuranceProduct)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody InsuranceProduct insuranceProduct) {
        return AjaxResult.success(insuranceProductService.save(insuranceProduct));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody InsuranceProduct insuranceProduct) {
        return AjaxResult.success(insuranceProductService.updateById(insuranceProduct));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(insuranceProductService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(insuranceProductService.getById(id));
    }
}
