package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.MarkeentityDetail;
import com.panda.zgqc.app.service.IMarkeentityDetailService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/markeentity/detail")
public class MarkeentityDetailController {
    @Autowired
    private IMarkeentityDetailService markeentityDetailService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, MarkeentityDetail markeentityDetail) {
        return AjaxResult.success(markeentityDetailService.page(pageEntity.toPage(), Wrappers.lambdaQuery(markeentityDetail)));
    }

    @GetMapping("/list")
    public AjaxResult list(MarkeentityDetail markeentityDetail) {
        return AjaxResult.success(markeentityDetailService.list(Wrappers.lambdaQuery(markeentityDetail)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody MarkeentityDetail markeentityDetail) {
        return AjaxResult.success(markeentityDetailService.save(markeentityDetail));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody MarkeentityDetail markeentityDetail) {
        return AjaxResult.success(markeentityDetailService.updateById(markeentityDetail));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(markeentityDetailService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(markeentityDetailService.getById(id));
    }
}
