package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.MeteorologyWarningRuleDetail;
import com.panda.zgqc.app.service.IMeteorologyWarningRuleDetailService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/meteorology/warning/rule/detail")
public class MeteorologyWarningRuleDetailController {
    @Autowired
    private IMeteorologyWarningRuleDetailService meteorologyWarningRuleDetailService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, MeteorologyWarningRuleDetail meteorologyWarningRuleDetail) {
        return AjaxResult.success(meteorologyWarningRuleDetailService.page(pageEntity.toPage(), Wrappers.lambdaQuery(meteorologyWarningRuleDetail)));
    }

    @GetMapping("/list")
    public AjaxResult list(MeteorologyWarningRuleDetail meteorologyWarningRuleDetail) {
        return AjaxResult.success(meteorologyWarningRuleDetailService.list(Wrappers.lambdaQuery(meteorologyWarningRuleDetail)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody MeteorologyWarningRuleDetail meteorologyWarningRuleDetail) {
        return AjaxResult.success(meteorologyWarningRuleDetailService.save(meteorologyWarningRuleDetail));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody MeteorologyWarningRuleDetail meteorologyWarningRuleDetail) {
        return AjaxResult.success(meteorologyWarningRuleDetailService.updateById(meteorologyWarningRuleDetail));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(meteorologyWarningRuleDetailService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(meteorologyWarningRuleDetailService.getById(id));
    }
}
