package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.MouseMonitorData;
import com.panda.zgqc.app.service.IMouseMonitorDataService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/mouse/monitor/data")
public class MouseMonitorDataController {
    @Autowired
    private IMouseMonitorDataService mouseMonitorDataService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, MouseMonitorData mouseMonitorData) {
        return AjaxResult.success(mouseMonitorDataService.page(pageEntity.toPage(), Wrappers.lambdaQuery(mouseMonitorData)));
    }

    @GetMapping("/list")
    public AjaxResult list(MouseMonitorData mouseMonitorData) {
        return AjaxResult.success(mouseMonitorDataService.list(Wrappers.lambdaQuery(mouseMonitorData)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody MouseMonitorData mouseMonitorData) {
        return AjaxResult.success(mouseMonitorDataService.save(mouseMonitorData));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody MouseMonitorData mouseMonitorData) {
        return AjaxResult.success(mouseMonitorDataService.updateById(mouseMonitorData));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(mouseMonitorDataService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(mouseMonitorDataService.getById(id));
    }
}
