package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.OrchardHosting;
import com.panda.zgqc.app.service.IOrchardHostingService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/orchard/hosting")
public class OrchardHostingController {
    @Autowired
    private IOrchardHostingService orchardHostingService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, OrchardHosting orchardHosting) {
        return AjaxResult.success(orchardHostingService.page(pageEntity.toPage(), Wrappers.lambdaQuery(orchardHosting)));
    }

    @GetMapping("/list")
    public AjaxResult list(OrchardHosting orchardHosting) {
        return AjaxResult.success(orchardHostingService.list(Wrappers.lambdaQuery(orchardHosting)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody OrchardHosting orchardHosting) {
        return AjaxResult.success(orchardHostingService.save(orchardHosting));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody OrchardHosting orchardHosting) {
        return AjaxResult.success(orchardHostingService.updateById(orchardHosting));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(orchardHostingService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(orchardHostingService.getById(id));
    }
}
