package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.ServiceDemand;
import com.panda.zgqc.app.service.IServiceDemandService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/service/demand")
public class ServiceDemandController {
    @Autowired
    private IServiceDemandService serviceDemandService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, ServiceDemand serviceDemand) {
        return AjaxResult.success(serviceDemandService.page(pageEntity.toPage(), Wrappers.lambdaQuery(serviceDemand)));
    }

    @GetMapping("/list")
    public AjaxResult list(ServiceDemand serviceDemand) {
        return AjaxResult.success(serviceDemandService.list(Wrappers.lambdaQuery(serviceDemand)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody ServiceDemand serviceDemand) {
        return AjaxResult.success(serviceDemandService.save(serviceDemand));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody ServiceDemand serviceDemand) {
        return AjaxResult.success(serviceDemandService.updateById(serviceDemand));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(serviceDemandService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(serviceDemandService.getById(id));
    }
}
