package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 经纪人代理
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_agent")
public class Agent {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 经纪人id
     */
    private String agentManagementId;
    /**
     * 经纪人姓名
     */
    private String agentName;
    /**
     * 经纪人电话
     */
    private String agentPhone;
    /**
     * 经纪人身份证号
     */
    private String agentIdentificationCard;
    /**
     * 最近登录时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime agentLastTime;
    /**
     * 状态:0启用 1禁用
     */
    private Integer managementState;
    /**
     * 删除与否:0未删除 1删除
     */
    private Boolean agentDelete;

    public Agent(Agent agent) {
        if (Objects.nonNull(agent)) {
            this.id = agent.id;
            this.sysId = agent.sysId;
            this.organizationId = agent.organizationId;
            this.createTime = agent.createTime;
            this.updateTime = agent.updateTime;
            this.agentManagementId = agent.agentManagementId;
            this.agentName = agent.agentName;
            this.agentPhone = agent.agentPhone;
            this.agentIdentificationCard = agent.agentIdentificationCard;
            this.agentLastTime = agent.agentLastTime;
            this.managementState = agent.managementState;
            this.agentDelete = agent.agentDelete;
        }
    }
}
