package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 包装管理（品牌服务）
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_brand_package")
public class BrandPackage {
    private static final long serialVersionUID = 1L;
    /**
     * 表自增id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 品牌包装id（32位uuid）
     */
    private String packageId;
    /**
     * 品牌包装名字
     */
    private String packageName;
    /**
     * 品牌包装图片合集
     */
    private String packageImage;
    /**
     * 品牌包装规格
     */
    private String packageSpecifications;
    /**
     * 备注
     */
    private String remark;
    /**
     * 是否置顶 （0-不置顶 1-置顶）
     */
    private Boolean isTop;
    /**
     * 启用/禁用（0-禁用  1-启用）
     */
    private Boolean isEnable;
    /**
     * 是否删除（0-未删除  1-已删除）
     */
    private Boolean isDeleted;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 操作人id
     */
    private String operator;
    /**
     * 操作人名称
     */
    private String operatorName;

    public BrandPackage(BrandPackage brandPackage) {
        if (Objects.nonNull(brandPackage)) {
            this.id = brandPackage.id;
            this.packageId = brandPackage.packageId;
            this.packageName = brandPackage.packageName;
            this.packageImage = brandPackage.packageImage;
            this.packageSpecifications = brandPackage.packageSpecifications;
            this.remark = brandPackage.remark;
            this.isTop = brandPackage.isTop;
            this.isEnable = brandPackage.isEnable;
            this.isDeleted = brandPackage.isDeleted;
            this.sysId = brandPackage.sysId;
            this.organizationId = brandPackage.organizationId;
            this.createTime = brandPackage.createTime;
            this.updateTime = brandPackage.updateTime;
            this.operator = brandPackage.operator;
            this.operatorName = brandPackage.operatorName;
        }
    }
}
