package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 码关联
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_code_relation")
public class CodeRelation {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 操作人id
     */
    private String operator;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 操作人名称
     */
    private String operatorName;
    /**
     * 删除标记 0:已删除，1：未删除
     */
    private Integer deleted;
    /**
     * 关联类型：1按号段、2单码
     */
    private Integer relationType;
    /**
     * 起始码
     */
    private String startCode;
    /**
     * 结束码
     */
    private String endCode;
    /**
     * 全局码批次
     */
    private String codeBatch;
    /**
     * 标识数量
     */
    private Integer quantity;
    /**
     * 单码
     */
    private String code;
    /**
     * 规格
     */
    private String specification;
    /**
     * 标识领取id
     */
    private Long tagReceiveId;
    /**
     * 主体ID
     */
    private String subjectId;
    /**
     * 是否同步浙农码 0:未同步，1：已同步
     */
    private Integer znmSync;

    public CodeRelation(CodeRelation codeRelation) {
        if (Objects.nonNull(codeRelation)) {
            this.id = codeRelation.id;
            this.sysId = codeRelation.sysId;
            this.organizationId = codeRelation.organizationId;
            this.operator = codeRelation.operator;
            this.createTime = codeRelation.createTime;
            this.updateTime = codeRelation.updateTime;
            this.operatorName = codeRelation.operatorName;
            this.deleted = codeRelation.deleted;
            this.relationType = codeRelation.relationType;
            this.startCode = codeRelation.startCode;
            this.endCode = codeRelation.endCode;
            this.codeBatch = codeRelation.codeBatch;
            this.quantity = codeRelation.quantity;
            this.code = codeRelation.code;
            this.specification = codeRelation.specification;
            this.tagReceiveId = codeRelation.tagReceiveId;
            this.subjectId = codeRelation.subjectId;
            this.znmSync = codeRelation.znmSync;
        }
    }
}
