package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 保险产品
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_insurance_product")
public class InsuranceProduct {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 创建时间/发布时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 保险产品id
     */
    private String insuranceProductId;
    /**
     * 保险产品名称
     */
    private String insuranceProductName;
    /**
     * 类型:默认0标准产品 1个性化产品
     */
    private Integer insuranceType;
    /**
     * 最高保额（元/亩）
     */
    private BigDecimal maxInsuranceMoney;
    /**
     * 保险费描述
     */
    private String premiumDescribe;
    /**
     * 保险期间描述
     */
    private String insurancePeriodDescribe;
    /**
     * 状态:默认0启用、1禁用
     */
    private Integer insuranceStatus;
    /**
     * 备注
     */
    private String insuranceRemark;
    /**
     * 是否删除  true已-删除  false-未删除
     */
    private Boolean insuranceDelete;

    public InsuranceProduct(InsuranceProduct insuranceProduct) {
        if (Objects.nonNull(insuranceProduct)) {
            this.id = insuranceProduct.id;
            this.sysId = insuranceProduct.sysId;
            this.organizationId = insuranceProduct.organizationId;
            this.createTime = insuranceProduct.createTime;
            this.updateTime = insuranceProduct.updateTime;
            this.insuranceProductId = insuranceProduct.insuranceProductId;
            this.insuranceProductName = insuranceProduct.insuranceProductName;
            this.insuranceType = insuranceProduct.insuranceType;
            this.maxInsuranceMoney = insuranceProduct.maxInsuranceMoney;
            this.premiumDescribe = insuranceProduct.premiumDescribe;
            this.insurancePeriodDescribe = insuranceProduct.insurancePeriodDescribe;
            this.insuranceStatus = insuranceProduct.insuranceStatus;
            this.insuranceRemark = insuranceProduct.insuranceRemark;
            this.insuranceDelete = insuranceProduct.insuranceDelete;
        }
    }
}
