package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 用工报名
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_labor_hire_enroll")
public class LaborHireEnroll {
    private static final long serialVersionUID = 1L;
    /**
     * 主键Id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 用工需求Id
     */
    private String laborHireId;
    /**
     * 报名主体Id
     */
    private String enrollSubjectId;
    /**
     * 报名主体名称
     */
    private String enrollSubjectName;
    /**
     * 报名录用状态 0:已取消 1:待确认 2:已录用 3:未录用
     */
    private Integer enrollStatus;

    public LaborHireEnroll(LaborHireEnroll laborHireEnroll) {
        if (Objects.nonNull(laborHireEnroll)) {
            this.id = laborHireEnroll.id;
            this.sysId = laborHireEnroll.sysId;
            this.organizationId = laborHireEnroll.organizationId;
            this.createTime = laborHireEnroll.createTime;
            this.updateTime = laborHireEnroll.updateTime;
            this.laborHireId = laborHireEnroll.laborHireId;
            this.enrollSubjectId = laborHireEnroll.enrollSubjectId;
            this.enrollSubjectName = laborHireEnroll.enrollSubjectName;
            this.enrollStatus = laborHireEnroll.enrollStatus;
        }
    }
}
