package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 政策法规
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_policy_regulations")
public class PolicyRegulations {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 系统id
     */
    private String organizationId;
    /**
     * 操作人id
     */
    private String operator;
    /**
     * 操作人姓名
     */
    private String operatorName;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 政策法规标题
     */
    private String policyTitle;
    /**
     * 发布单位
     */
    private String issueUnit;
    /**
     * 阅读量
     */
    private Integer readingNumber;
    /**
     * 点赞数量
     */
    private Integer likeNumber;
    /**
     * 转发数量
     */
    private Integer transmitNumber;
    /**
     * 是否允许转发：0允许1不允许
     */
    private Integer allowTransmit;
    /**
     * 状态：0启用 1禁用
     */
    private Integer policyState;
    /**
     * 是否置顶：0不置顶 1置顶
     */
    private Integer policyTop;
    /**
     * 正文详情
     */
    private String bodyDetails;
    /**
     * 是否删除  true已-删除  false-未删除
     */
    private Boolean deleteKey;

    public PolicyRegulations(PolicyRegulations policyRegulations) {
        if (Objects.nonNull(policyRegulations)) {
            this.id = policyRegulations.id;
            this.sysId = policyRegulations.sysId;
            this.organizationId = policyRegulations.organizationId;
            this.operator = policyRegulations.operator;
            this.operatorName = policyRegulations.operatorName;
            this.createTime = policyRegulations.createTime;
            this.updateTime = policyRegulations.updateTime;
            this.policyTitle = policyRegulations.policyTitle;
            this.issueUnit = policyRegulations.issueUnit;
            this.readingNumber = policyRegulations.readingNumber;
            this.likeNumber = policyRegulations.likeNumber;
            this.transmitNumber = policyRegulations.transmitNumber;
            this.allowTransmit = policyRegulations.allowTransmit;
            this.policyState = policyRegulations.policyState;
            this.policyTop = policyRegulations.policyTop;
            this.bodyDetails = policyRegulations.bodyDetails;
            this.deleteKey = policyRegulations.deleteKey;
        }
    }
}
