package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * QA知识库分类
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_qa_protect_classify")
public class QaProtecclassify {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 创建时间/发布时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 维护分类id
     */
    private String protectClassifyId;
    /**
     * 分类名称
     */
    private String classifyName;
    /**
     * 分类图标
     */
    private String classifyPicture;
    /**
     * 删除：flase未删除 true删除
     */
    private Boolean paDelete;

    public QaProtecclassify(QaProtecclassify qaProtecclassify) {
        if (Objects.nonNull(qaProtecclassify)) {
            this.id = qaProtecclassify.id;
            this.sysId = qaProtecclassify.sysId;
            this.organizationId = qaProtecclassify.organizationId;
            this.createTime = qaProtecclassify.createTime;
            this.updateTime = qaProtecclassify.updateTime;
            this.protectClassifyId = qaProtecclassify.protectClassifyId;
            this.classifyName = qaProtecclassify.classifyName;
            this.classifyPicture = qaProtecclassify.classifyPicture;
            this.paDelete = qaProtecclassify.paDelete;
        }
    }
}
