package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;

/**
 * 销售果园价格详情
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_sale_orchard_detail")
public class SaleOrchardDetail {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 销售果园Id
     */
    private String saleOrchardId;
    /**
     * 种植品种类型
     */
    private Integer plantType;
    /**
     * 商品类型 1成果 2 种苗
     */
    private Integer productType;
    /**
     * 种植品种名称
     */
    private String plantTypeName;
    /**
     * 价格
     */
    private BigDecimal price;
    /**
     * 可供应量
     */
    private BigDecimal remain;
    /**
     * 最小供应量
     */
    private BigDecimal minimumSupply;
    /**
     * 备注
     */
    private String remark;
    /**
     * 图片
     */
    private String image;
    /**
     * 可供货时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate supplyDate;

    public SaleOrchardDetail(SaleOrchardDetail saleOrchardDetail) {
        if (Objects.nonNull(saleOrchardDetail)) {
            this.id = saleOrchardDetail.id;
            this.saleOrchardId = saleOrchardDetail.saleOrchardId;
            this.plantType = saleOrchardDetail.plantType;
            this.productType = saleOrchardDetail.productType;
            this.plantTypeName = saleOrchardDetail.plantTypeName;
            this.price = saleOrchardDetail.price;
            this.remain = saleOrchardDetail.remain;
            this.minimumSupply = saleOrchardDetail.minimumSupply;
            this.remark = saleOrchardDetail.remark;
            this.image = saleOrchardDetail.image;
            this.supplyDate = saleOrchardDetail.supplyDate;
        }
    }
}
