package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.AuthorizationListimeScope;
import com.panda.zgqc.app.service.IAuthorizationListimeScopeService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/authorization/listime/scope")
public class AuthorizationListimeScopeController {
    @Autowired
    private IAuthorizationListimeScopeService authorizationListimeScopeService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, AuthorizationListimeScope authorizationListimeScope) {
        return AjaxResult.success(authorizationListimeScopeService.page(pageEntity.toPage(), Wrappers.lambdaQuery(authorizationListimeScope)));
    }

    @GetMapping("/list")
    public AjaxResult list(AuthorizationListimeScope authorizationListimeScope) {
        return AjaxResult.success(authorizationListimeScopeService.list(Wrappers.lambdaQuery(authorizationListimeScope)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody AuthorizationListimeScope authorizationListimeScope) {
        return AjaxResult.success(authorizationListimeScopeService.save(authorizationListimeScope));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody AuthorizationListimeScope authorizationListimeScope) {
        return AjaxResult.success(authorizationListimeScopeService.updateById(authorizationListimeScope));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(authorizationListimeScopeService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(authorizationListimeScopeService.getById(id));
    }
}
