package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.BrandPackageApply;
import com.panda.zgqc.app.service.IBrandPackageApplyService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/brand/package/apply")
public class BrandPackageApplyController {
    @Autowired
    private IBrandPackageApplyService brandPackageApplyService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, BrandPackageApply brandPackageApply) {
        return AjaxResult.success(brandPackageApplyService.page(pageEntity.toPage(), Wrappers.lambdaQuery(brandPackageApply)));
    }

    @GetMapping("/list")
    public AjaxResult list(BrandPackageApply brandPackageApply) {
        return AjaxResult.success(brandPackageApplyService.list(Wrappers.lambdaQuery(brandPackageApply)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody BrandPackageApply brandPackageApply) {
        return AjaxResult.success(brandPackageApplyService.save(brandPackageApply));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody BrandPackageApply brandPackageApply) {
        return AjaxResult.success(brandPackageApplyService.updateById(brandPackageApply));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Integer[] ids) {
        return AjaxResult.success(brandPackageApplyService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Integer id) {
        return AjaxResult.success(brandPackageApplyService.getById(id));
    }
}
