package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.CodeRelation;
import com.panda.zgqc.app.service.ICodeRelationService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/code/relation")
public class CodeRelationController {
    @Autowired
    private ICodeRelationService codeRelationService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, CodeRelation codeRelation) {
        return AjaxResult.success(codeRelationService.page(pageEntity.toPage(), Wrappers.lambdaQuery(codeRelation)));
    }

    @GetMapping("/list")
    public AjaxResult list(CodeRelation codeRelation) {
        return AjaxResult.success(codeRelationService.list(Wrappers.lambdaQuery(codeRelation)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody CodeRelation codeRelation) {
        return AjaxResult.success(codeRelationService.save(codeRelation));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody CodeRelation codeRelation) {
        return AjaxResult.success(codeRelationService.updateById(codeRelation));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(codeRelationService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(codeRelationService.getById(id));
    }
}
