package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.DiseasePesstoreRelation;
import com.panda.zgqc.app.service.IDiseasePesstoreRelationService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/disease/pesstore/relation")
public class DiseasePesstoreRelationController {
    @Autowired
    private IDiseasePesstoreRelationService diseasePesstoreRelationService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, DiseasePesstoreRelation diseasePesstoreRelation) {
        return AjaxResult.success(diseasePesstoreRelationService.page(pageEntity.toPage(), Wrappers.lambdaQuery(diseasePesstoreRelation)));
    }

    @GetMapping("/list")
    public AjaxResult list(DiseasePesstoreRelation diseasePesstoreRelation) {
        return AjaxResult.success(diseasePesstoreRelationService.list(Wrappers.lambdaQuery(diseasePesstoreRelation)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody DiseasePesstoreRelation diseasePesstoreRelation) {
        return AjaxResult.success(diseasePesstoreRelationService.save(diseasePesstoreRelation));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody DiseasePesstoreRelation diseasePesstoreRelation) {
        return AjaxResult.success(diseasePesstoreRelationService.updateById(diseasePesstoreRelation));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(diseasePesstoreRelationService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(diseasePesstoreRelationService.getById(id));
    }
}
