package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.DiseasePest;
import com.panda.zgqc.app.service.IDiseasePestService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/disease/pest")
public class DiseasePestController {
    @Autowired
    private IDiseasePestService diseasePestService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, DiseasePest diseasePest) {
        return AjaxResult.success(diseasePestService.page(pageEntity.toPage(), Wrappers.lambdaQuery(diseasePest)));
    }

    @GetMapping("/list")
    public AjaxResult list(DiseasePest diseasePest) {
        return AjaxResult.success(diseasePestService.list(Wrappers.lambdaQuery(diseasePest)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody DiseasePest diseasePest) {
        return AjaxResult.success(diseasePestService.save(diseasePest));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody DiseasePest diseasePest) {
        return AjaxResult.success(diseasePestService.updateById(diseasePest));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(diseasePestService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(diseasePestService.getById(id));
    }
}
