package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.Insecdevice;
import com.panda.zgqc.app.service.IInsecdeviceService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/insecdevice")
public class InsecdeviceController {
    @Autowired
    private IInsecdeviceService insecdeviceService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, Insecdevice insecdevice) {
        return AjaxResult.success(insecdeviceService.page(pageEntity.toPage(), Wrappers.lambdaQuery(insecdevice)));
    }

    @GetMapping("/list")
    public AjaxResult list(Insecdevice insecdevice) {
        return AjaxResult.success(insecdeviceService.list(Wrappers.lambdaQuery(insecdevice)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody Insecdevice insecdevice) {
        return AjaxResult.success(insecdeviceService.save(insecdevice));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody Insecdevice insecdevice) {
        return AjaxResult.success(insecdeviceService.updateById(insecdevice));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(insecdeviceService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(insecdeviceService.getById(id));
    }
}
