package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.InsecmonitorData;
import com.panda.zgqc.app.service.IInsecmonitorDataService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/insecmonitor/data")
public class InsecmonitorDataController {
    @Autowired
    private IInsecmonitorDataService insecmonitorDataService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, InsecmonitorData insecmonitorData) {
        return AjaxResult.success(insecmonitorDataService.page(pageEntity.toPage(), Wrappers.lambdaQuery(insecmonitorData)));
    }

    @GetMapping("/list")
    public AjaxResult list(InsecmonitorData insecmonitorData) {
        return AjaxResult.success(insecmonitorDataService.list(Wrappers.lambdaQuery(insecmonitorData)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody InsecmonitorData insecmonitorData) {
        return AjaxResult.success(insecmonitorDataService.save(insecmonitorData));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody InsecmonitorData insecmonitorData) {
        return AjaxResult.success(insecmonitorDataService.updateById(insecmonitorData));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(insecmonitorDataService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(insecmonitorDataService.getById(id));
    }
}
