package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.LandInformation;
import com.panda.zgqc.app.service.ILandInformationService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/land/information")
public class LandInformationController {
    @Autowired
    private ILandInformationService landInformationService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, LandInformation landInformation) {
        return AjaxResult.success(landInformationService.page(pageEntity.toPage(), Wrappers.lambdaQuery(landInformation)));
    }

    @GetMapping("/list")
    public AjaxResult list(LandInformation landInformation) {
        return AjaxResult.success(landInformationService.list(Wrappers.lambdaQuery(landInformation)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody LandInformation landInformation) {
        return AjaxResult.success(landInformationService.save(landInformation));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody LandInformation landInformation) {
        return AjaxResult.success(landInformationService.updateById(landInformation));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(landInformationService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(landInformationService.getById(id));
    }
}
