package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.PersonalizedRecommendation;
import com.panda.zgqc.app.service.IPersonalizedRecommendationService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/personalized/recommendation")
public class PersonalizedRecommendationController {
    @Autowired
    private IPersonalizedRecommendationService personalizedRecommendationService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, PersonalizedRecommendation personalizedRecommendation) {
        return AjaxResult.success(personalizedRecommendationService.page(pageEntity.toPage(), Wrappers.lambdaQuery(personalizedRecommendation)));
    }

    @GetMapping("/list")
    public AjaxResult list(PersonalizedRecommendation personalizedRecommendation) {
        return AjaxResult.success(personalizedRecommendationService.list(Wrappers.lambdaQuery(personalizedRecommendation)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody PersonalizedRecommendation personalizedRecommendation) {
        return AjaxResult.success(personalizedRecommendationService.save(personalizedRecommendation));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody PersonalizedRecommendation personalizedRecommendation) {
        return AjaxResult.success(personalizedRecommendationService.updateById(personalizedRecommendation));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(personalizedRecommendationService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(personalizedRecommendationService.getById(id));
    }
}
