package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.PolicyRegulations;
import com.panda.zgqc.app.service.IPolicyRegulationsService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/policy/regulations")
public class PolicyRegulationsController {
    @Autowired
    private IPolicyRegulationsService policyRegulationsService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, PolicyRegulations policyRegulations) {
        return AjaxResult.success(policyRegulationsService.page(pageEntity.toPage(), Wrappers.lambdaQuery(policyRegulations)));
    }

    @GetMapping("/list")
    public AjaxResult list(PolicyRegulations policyRegulations) {
        return AjaxResult.success(policyRegulationsService.list(Wrappers.lambdaQuery(policyRegulations)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody PolicyRegulations policyRegulations) {
        return AjaxResult.success(policyRegulationsService.save(policyRegulations));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody PolicyRegulations policyRegulations) {
        return AjaxResult.success(policyRegulationsService.updateById(policyRegulations));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(policyRegulationsService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(policyRegulationsService.getById(id));
    }
}
