package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.QaProtecclassify;
import com.panda.zgqc.app.service.IQaProtecclassifyService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/qa/protecclassify")
public class QaProtecclassifyController {
    @Autowired
    private IQaProtecclassifyService qaProtecclassifyService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, QaProtecclassify qaProtecclassify) {
        return AjaxResult.success(qaProtecclassifyService.page(pageEntity.toPage(), Wrappers.lambdaQuery(qaProtecclassify)));
    }

    @GetMapping("/list")
    public AjaxResult list(QaProtecclassify qaProtecclassify) {
        return AjaxResult.success(qaProtecclassifyService.list(Wrappers.lambdaQuery(qaProtecclassify)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody QaProtecclassify qaProtecclassify) {
        return AjaxResult.success(qaProtecclassifyService.save(qaProtecclassify));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody QaProtecclassify qaProtecclassify) {
        return AjaxResult.success(qaProtecclassifyService.updateById(qaProtecclassify));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(qaProtecclassifyService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(qaProtecclassifyService.getById(id));
    }
}
