package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 主体风采展示
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_brand_entity_show")
public class BrandEntityShow {
    private static final long serialVersionUID = 1L;
    /**
     * 表自增id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 操作人id/风采展示id
     */
    private String operator;
    /**
     * 操作人名称/主体名称
     */
    private String operatorName;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 风采展示uuid
     */
    private String entityShowId;
    /**
     * 联系方式
     */
    private String phone;
    /**
     * 基地介绍
     */
    private String baseIntroduce;
    /**
     * 宣传图片
     */
    private String propagateImage;
    /**
     * 检查报告
     */
    private String examiningReport;

    public BrandEntityShow(BrandEntityShow brandEntityShow) {
        if (Objects.nonNull(brandEntityShow)) {
            this.id = brandEntityShow.id;
            this.sysId = brandEntityShow.sysId;
            this.organizationId = brandEntityShow.organizationId;
            this.operator = brandEntityShow.operator;
            this.operatorName = brandEntityShow.operatorName;
            this.createTime = brandEntityShow.createTime;
            this.updateTime = brandEntityShow.updateTime;
            this.entityShowId = brandEntityShow.entityShowId;
            this.phone = brandEntityShow.phone;
            this.baseIntroduce = brandEntityShow.baseIntroduce;
            this.propagateImage = brandEntityShow.propagateImage;
            this.examiningReport = brandEntityShow.examiningReport;
        }
    }
}
