package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 包装申请明细（品牌服务）
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_brand_package_apply_detail")
public class BrandPackageApplyDetail {
    private static final long serialVersionUID = 1L;
    /**
     * 自增id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 包装申请id
     */
    private String applyId;
    /**
     * 品牌包装id（为空则表示是个性化申请）
     */
    private String packageId;
    /**
     * 品牌包装名字
     */
    private String packageName;
    /**
     * 品牌包装图片合集
     */
    private String packageImage;
    /**
     * 印刷/采购数量
     */
    private Integer number;
    /**
     * 备注
     */
    private String remark;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 操作人id
     */
    private String operator;
    /**
     * 操作人名称
     */
    private String operatorName;

    public BrandPackageApplyDetail(BrandPackageApplyDetail brandPackageApplyDetail) {
        if (Objects.nonNull(brandPackageApplyDetail)) {
            this.id = brandPackageApplyDetail.id;
            this.applyId = brandPackageApplyDetail.applyId;
            this.packageId = brandPackageApplyDetail.packageId;
            this.packageName = brandPackageApplyDetail.packageName;
            this.packageImage = brandPackageApplyDetail.packageImage;
            this.number = brandPackageApplyDetail.number;
            this.remark = brandPackageApplyDetail.remark;
            this.sysId = brandPackageApplyDetail.sysId;
            this.organizationId = brandPackageApplyDetail.organizationId;
            this.createTime = brandPackageApplyDetail.createTime;
            this.updateTime = brandPackageApplyDetail.updateTime;
            this.operator = brandPackageApplyDetail.operator;
            this.operatorName = brandPackageApplyDetail.operatorName;
        }
    }
}
