package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 文件和模板回调通知（e签宝）
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_contract_fill_callback")
public class ContracfillCallback {
    private static final long serialVersionUID = 1L;
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 事件
     */
    private String action;
    /**
     * 控件填写信息
     */
    private String components;
    /**
     * 自定义业务编号
     */
    private String customBizNum;
    /**
     * 模板id
     */
    private String docTemplateId;
    /**
     * 模板名称
     */
    private String docTemplateName;
    /**
     * 文件id
     */
    private String fileId;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 回调时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime callTime;

    public ContracfillCallback(ContracfillCallback contracfillCallback) {
        if (Objects.nonNull(contracfillCallback)) {
            this.id = contracfillCallback.id;
            this.action = contracfillCallback.action;
            this.components = contracfillCallback.components;
            this.customBizNum = contracfillCallback.customBizNum;
            this.docTemplateId = contracfillCallback.docTemplateId;
            this.docTemplateName = contracfillCallback.docTemplateName;
            this.fileId = contracfillCallback.fileId;
            this.createTime = contracfillCallback.createTime;
            this.updateTime = contracfillCallback.updateTime;
            this.callTime = contracfillCallback.callTime;
        }
    }
}
