package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 已填写的合同信息
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_contract_finish")
public class Contracfinish {
    private static final long serialVersionUID = 1L;
    /**
     * 自增id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 托管需求发布人id（甲方）
     */
    private String farmerId;
    /**
     * 合同生成人id（乙方）
     */
    private String serverId;
    /**
     * 托管编号
     */
    private String orchardCode;
    /**
     * 合同id（e签宝）
     */
    private String fileId;
    /**
     * 模板id
     */
    private String docTemplateId;
    /**
     * 模板名字
     */
    private String docTemplateName;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 回调时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime callTime;
    /**
     * 控件填写信息
     */
    private String components;
    /**
     * 合同编号
     */
    private String contractCode;
    /**
     * 托管需求发布人姓名（甲方）
     */
    private String farmerName;
    /**
     * 合同生成人姓名（乙方）
     */
    private String serverName;
    /**
     * 托管需求发布人身份证号（甲方）
     */
    private String farmerIdCard;
    /**
     * 合同生成人身份账号（乙方）
     */
    private String serverIdCard;
    /**
     * 0-待签约 1-签约中 2-已取消  3-已签约
     */
    private Integer contractStatus;
    /**
     * 签署合同时附件
     */
    private String attments;
    /**
     * 签署流程id（e签宝方接口返回）
     */
    private String signFlowId;
    /**
     * 托管需求发布人是否已签署(甲方)  true-已签署  false-未签署
     */
    private Boolean farmerSigned;
    /**
     * 合同生成人是否已签署(乙方) true-已签署  false-未签署
     */
    private Boolean serverSigned;
    /**
     * 托管需求发布人电话（甲方）
     */
    private String farmerMobile;
    /**
     * 合同生成人电话（乙方）
     */
    private String serverMobile;
    /**
     * 托管需求发布人签署时间（甲方）
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime farmerSignTime;
    /**
     * 合同生成人签署时间（乙方）
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime serverSignTime;
    /**
     * 合同取消时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime cancelTime;
    /**
     * 乙方确认合同时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime serverConfirmTime;
    /**
     * 甲方确认合同时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime farmerConfirmTime;
    /**
     * 合同取消人
     */
    private String cancelPersonId;

    public Contracfinish(Contracfinish contracfinish) {
        if (Objects.nonNull(contracfinish)) {
            this.id = contracfinish.id;
            this.farmerId = contracfinish.farmerId;
            this.serverId = contracfinish.serverId;
            this.orchardCode = contracfinish.orchardCode;
            this.fileId = contracfinish.fileId;
            this.docTemplateId = contracfinish.docTemplateId;
            this.docTemplateName = contracfinish.docTemplateName;
            this.createTime = contracfinish.createTime;
            this.updateTime = contracfinish.updateTime;
            this.callTime = contracfinish.callTime;
            this.components = contracfinish.components;
            this.contractCode = contracfinish.contractCode;
            this.farmerName = contracfinish.farmerName;
            this.serverName = contracfinish.serverName;
            this.farmerIdCard = contracfinish.farmerIdCard;
            this.serverIdCard = contracfinish.serverIdCard;
            this.contractStatus = contracfinish.contractStatus;
            this.attments = contracfinish.attments;
            this.signFlowId = contracfinish.signFlowId;
            this.farmerSigned = contracfinish.farmerSigned;
            this.serverSigned = contracfinish.serverSigned;
            this.farmerMobile = contracfinish.farmerMobile;
            this.serverMobile = contracfinish.serverMobile;
            this.farmerSignTime = contracfinish.farmerSignTime;
            this.serverSignTime = contracfinish.serverSignTime;
            this.cancelTime = contracfinish.cancelTime;
            this.serverConfirmTime = contracfinish.serverConfirmTime;
            this.farmerConfirmTime = contracfinish.farmerConfirmTime;
            this.cancelPersonId = contracfinish.cancelPersonId;
        }
    }
}
