package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 病虫害-防止方法
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_disease_pest_prevention_method")
public class DiseasePespreventionMethod {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 病虫害编号
     */
    private String diseasePestCode;
    /**
     * 方法详情
     */
    private String methodDetail;
    /**
     * 方法分类 0-农业防治、1-物理防治、2-生物防治、3-化学防治、4-综合治理策略
     */
    private Integer methodSort;

    public DiseasePespreventionMethod(DiseasePespreventionMethod diseasePespreventionMethod) {
        if (Objects.nonNull(diseasePespreventionMethod)) {
            this.id = diseasePespreventionMethod.id;
            this.createTime = diseasePespreventionMethod.createTime;
            this.updateTime = diseasePespreventionMethod.updateTime;
            this.diseasePestCode = diseasePespreventionMethod.diseasePestCode;
            this.methodDetail = diseasePespreventionMethod.methodDetail;
            this.methodSort = diseasePespreventionMethod.methodSort;
        }
    }
}
