package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_disease_pest")
public class DiseasePest {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 操作人id
     */
    private String operator;
    /**
     * 操作人名称
     */
    private String operatorName;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 病虫害识别图片存储链接
     */
    private String recognizeImg;
    /**
     * 病虫害id
     */
    private String diseasePestCode;
    /**
     * 相似度
     */
    private BigDecimal similarity;
    /**
     * 病虫害学术名称
     */
    private String diseasePestName;
    /**
     * 病虫害通俗名称
     */
    private String commonNameSort;
    /**
     * 典型图片链接
     */
    private String typicalImg;
    /**
     * 类型：D 为病害, P 为虫害,N 天敌，G 草害，X 生理性病害
     */
    private String type;
    /**
     * 用户类型
     */
    private Integer subjectType;
    /**
     * 用户id
     */
    private String subjectId;
    /**
     * 主体名称
     */
    private String subjectName;
    /**
     * 账号
     */
    private String mobileId;
    /**
     * 地址
     */
    private String address;

    public DiseasePest(DiseasePest diseasePest) {
        if (Objects.nonNull(diseasePest)) {
            this.id = diseasePest.id;
            this.sysId = diseasePest.sysId;
            this.organizationId = diseasePest.organizationId;
            this.operator = diseasePest.operator;
            this.operatorName = diseasePest.operatorName;
            this.createTime = diseasePest.createTime;
            this.updateTime = diseasePest.updateTime;
            this.recognizeImg = diseasePest.recognizeImg;
            this.diseasePestCode = diseasePest.diseasePestCode;
            this.similarity = diseasePest.similarity;
            this.diseasePestName = diseasePest.diseasePestName;
            this.commonNameSort = diseasePest.commonNameSort;
            this.typicalImg = diseasePest.typicalImg;
            this.type = diseasePest.type;
            this.subjectType = diseasePest.subjectType;
            this.subjectId = diseasePest.subjectId;
            this.subjectName = diseasePest.subjectName;
            this.mobileId = diseasePest.mobileId;
            this.address = diseasePest.address;
        }
    }
}
