package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 地块信息
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_land_information")
public class LandInformation {
    private static final long serialVersionUID = 1L;
    /**
     * 自增id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 地块编号
     */
    private String landId;
    /**
     * 权利人
     */
    private String obligee;
    /**
     * 身份证号
     */
    private String idCardNumber;
    /**
     * 手机号
     */
    private String telephone;
    /**
     * 乡镇街道名称
     */
    private String townshipStreet;
    /**
     * 乡镇街道代码
     */
    private String townshipStreetCode;
    /**
     * 行政村名称
     */
    private String naturalVillage;
    /**
     * 行政村代码
     */
    private String naturalVillageCode;
    /**
     * 组号
     */
    private String groupId;
    /**
     * 种植品种
     */
    private String plantingVariety;
    /**
     * 种植面积
     */
    private BigDecimal plantingArea;
    /**
     * 树龄
     */
    private Integer treeAge;
    /**
     * 株数
     */
    private Integer treeNumber;
    /**
     * 上季度均产
     */
    private BigDecimal avgProductionLastQuarter;
    /**
     * 今季度估产
     */
    private BigDecimal estimateProductionQuarter;
    /**
     * 上产季价格
     */
    private BigDecimal lastQuarterPrice;
    /**
     * 海拔
     */
    private BigDecimal altitude;
    /**
     * 地势
     */
    private String terrain;
    /**
     * 坡向
     */
    private String slopeDirection;
    /**
     * 地类编码
     */
    private String landTypeCode;
    /**
     * 地类名称
     */
    private String landTypeName;
    /**
     * 耕地质量等级
     */
    private String landQualityLevel;
    /**
     * 是否高接换种  1-已换种  0-未换种
     */
    private String highConnectionReplaced;
    /**
     * 高接换种前品种
     */
    private String varietyBeforeReplaced;
    /**
     * 高接换种时间 yyyy-MM-dd
     */
    private String replacedTime;
    /**
     * 是否存在土地流转  1-流转  0-未流转
     */
    private String landCirculation;
    /**
     * 合同签订时间 yyyy-MM-dd
     */
    private String contractSignTime;
    /**
     * 合同年限
     */
    private String contractTerm;
    /**
     * 备注
     */
    private String remarks;
    /**
     * 是否删除  1-未删除  0-已删除
     */
    private Integer deleted;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 用户id(账号id)
     */
    private String userId;
    /**
     * geojson矢量数据类型
     */
    private String type;
    /**
     * geojson矢量数据
     */
    private String coordinates;
    /**
     * 采集人员(用户)
     */
    private String collectPerson;

    public LandInformation(LandInformation landInformation) {
        if (Objects.nonNull(landInformation)) {
            this.id = landInformation.id;
            this.landId = landInformation.landId;
            this.obligee = landInformation.obligee;
            this.idCardNumber = landInformation.idCardNumber;
            this.telephone = landInformation.telephone;
            this.townshipStreet = landInformation.townshipStreet;
            this.townshipStreetCode = landInformation.townshipStreetCode;
            this.naturalVillage = landInformation.naturalVillage;
            this.naturalVillageCode = landInformation.naturalVillageCode;
            this.groupId = landInformation.groupId;
            this.plantingVariety = landInformation.plantingVariety;
            this.plantingArea = landInformation.plantingArea;
            this.treeAge = landInformation.treeAge;
            this.treeNumber = landInformation.treeNumber;
            this.avgProductionLastQuarter = landInformation.avgProductionLastQuarter;
            this.estimateProductionQuarter = landInformation.estimateProductionQuarter;
            this.lastQuarterPrice = landInformation.lastQuarterPrice;
            this.altitude = landInformation.altitude;
            this.terrain = landInformation.terrain;
            this.slopeDirection = landInformation.slopeDirection;
            this.landTypeCode = landInformation.landTypeCode;
            this.landTypeName = landInformation.landTypeName;
            this.landQualityLevel = landInformation.landQualityLevel;
            this.highConnectionReplaced = landInformation.highConnectionReplaced;
            this.varietyBeforeReplaced = landInformation.varietyBeforeReplaced;
            this.replacedTime = landInformation.replacedTime;
            this.landCirculation = landInformation.landCirculation;
            this.contractSignTime = landInformation.contractSignTime;
            this.contractTerm = landInformation.contractTerm;
            this.remarks = landInformation.remarks;
            this.deleted = landInformation.deleted;
            this.createTime = landInformation.createTime;
            this.updateTime = landInformation.updateTime;
            this.organizationId = landInformation.organizationId;
            this.sysId = landInformation.sysId;
            this.userId = landInformation.userId;
            this.type = landInformation.type;
            this.coordinates = landInformation.coordinates;
            this.collectPerson = landInformation.collectPerson;
        }
    }
}
