package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 政策法规点赞用户关联
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_like_relationship")
public class LikeRelationship {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 创建时间/发布时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 点赞人id
     */
    private String likePeopleId;
    /**
     * 政策法规标识id
     */
    private Integer policyId;
    /**
     * 状态:0未点赞 1点过赞
     */
    private Integer likeOrNot;

    public LikeRelationship(LikeRelationship likeRelationship) {
        if (Objects.nonNull(likeRelationship)) {
            this.id = likeRelationship.id;
            this.sysId = likeRelationship.sysId;
            this.organizationId = likeRelationship.organizationId;
            this.createTime = likeRelationship.createTime;
            this.updateTime = likeRelationship.updateTime;
            this.likePeopleId = likeRelationship.likePeopleId;
            this.policyId = likeRelationship.policyId;
            this.likeOrNot = likeRelationship.likeOrNot;
        }
    }
}
