package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 预警规则级别设置
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_meteorology_warning_rule_detail")
public class MeteorologyWarningRuleDetail {
    private static final long serialVersionUID = 1L;
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 指标id
     */
    private String detailId;
    /**
     * 预警规则id
     */
    private String ruleId;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 预警指标类型 1-温度 2-相对湿度 3-天气 4-风级 5-风向
     */
    private Integer detailType;
    /**
     * 阈值范围类型 1:< 2:> 3:= 4:>= 5:<= 6:[x1,x2) 7:(x1,x2] 8:[x1,x2] 9:(x1,x2)
     */
    private Integer thresholdType;
    /**
     * 阈值范围开始，如为单值，则开始和结束传一样的值
     */
    private String thresholdStart;
    /**
     * 阈值范围结束，如为单值，则开始和结束传一样的值
     */
    private String thresholdEnd;
    /**
     * 持续时间
     */
    private Integer timeValue;
    /**
     * 时间单位 1-小时  2-天
     */
    private Integer timeType;
    /**
     * 条件顺序 仅1或2
     */
    private Integer conditionOrder;

    public MeteorologyWarningRuleDetail(MeteorologyWarningRuleDetail meteorologyWarningRuleDetail) {
        if (Objects.nonNull(meteorologyWarningRuleDetail)) {
            this.id = meteorologyWarningRuleDetail.id;
            this.detailId = meteorologyWarningRuleDetail.detailId;
            this.ruleId = meteorologyWarningRuleDetail.ruleId;
            this.createTime = meteorologyWarningRuleDetail.createTime;
            this.updateTime = meteorologyWarningRuleDetail.updateTime;
            this.detailType = meteorologyWarningRuleDetail.detailType;
            this.thresholdType = meteorologyWarningRuleDetail.thresholdType;
            this.thresholdStart = meteorologyWarningRuleDetail.thresholdStart;
            this.thresholdEnd = meteorologyWarningRuleDetail.thresholdEnd;
            this.timeValue = meteorologyWarningRuleDetail.timeValue;
            this.timeType = meteorologyWarningRuleDetail.timeType;
            this.conditionOrder = meteorologyWarningRuleDetail.conditionOrder;
        }
    }
}
