package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 鼠害监测数据
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_mouse_monitor_data")
public class MouseMonitorData {
    private static final long serialVersionUID = 1L;
    @TableId(type = IdType.AUTO)
    private Long id;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    private String deviceCode;
    private String deviceName;
    private String habitatname;
    private String humidity;
    private String locationName;
    private BigDecimal weight;
    private String temperature;
    private Integer source;

    public MouseMonitorData(MouseMonitorData mouseMonitorData) {
        if (Objects.nonNull(mouseMonitorData)) {
            this.id = mouseMonitorData.id;
            this.createTime = mouseMonitorData.createTime;
            this.deviceCode = mouseMonitorData.deviceCode;
            this.deviceName = mouseMonitorData.deviceName;
            this.habitatname = mouseMonitorData.habitatname;
            this.humidity = mouseMonitorData.humidity;
            this.locationName = mouseMonitorData.locationName;
            this.weight = mouseMonitorData.weight;
            this.temperature = mouseMonitorData.temperature;
            this.source = mouseMonitorData.source;
        }
    }
}
