package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 果园托管表
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_orchard_hosting")
public class OrchardHosting {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 操作人id
     */
    private String operator;
    /**
     * 操作人名称
     */
    private String operatorName;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 托管果园编号
     */
    private String orchardCode;
    /**
     * 农户Id
     */
    private String farmerId;
    /**
     * 产权方
     */
    private String owner;
    /**
     * 服务方
     */
    private String server;
    /**
     * 服务方Id
     */
    private String serverId;
    /**
     * 托管标题
     */
    private String orchardTitle;
    /**
     * 果园图片
     */
    private String orchardImages;
    /**
     * 果园地块数量
     */
    private Integer orchardGardenCount;
    /**
     * 果园地块编号
     */
    private String gardenCode;
    /**
     * 托管金额
     */
    private BigDecimal orchardMoney;
    /**
     * 种植品种
     */
    private String plantType;
    /**
     * 果园地址
     */
    private String orchardAddress;
    /**
     * 地址区域经纬度
     */
    private String addressLonAndLat;
    /**
     * 托管开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate hostingStartTime;
    /**
     * 托管结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate hostingEndTime;
    /**
     * 托管要求
     */
    private String hostingRequire;
    /**
     * 果园情况
     */
    private String orchardIntroduce;
    /**
     * 托管状态： 0待托管 1待确认 2签约中 3托管中 4 已结束 5 已关闭
     */
    private Integer hostingStatus;
    /**
     * 关闭时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime closeTime;
    /**
     * 果园面积
     */
    private BigDecimal orchardArea;
    /**
     * 合同编号（回显）
     */
    private String contractCode;

    public OrchardHosting(OrchardHosting orchardHosting) {
        if (Objects.nonNull(orchardHosting)) {
            this.id = orchardHosting.id;
            this.sysId = orchardHosting.sysId;
            this.organizationId = orchardHosting.organizationId;
            this.operator = orchardHosting.operator;
            this.operatorName = orchardHosting.operatorName;
            this.createTime = orchardHosting.createTime;
            this.updateTime = orchardHosting.updateTime;
            this.orchardCode = orchardHosting.orchardCode;
            this.farmerId = orchardHosting.farmerId;
            this.owner = orchardHosting.owner;
            this.server = orchardHosting.server;
            this.serverId = orchardHosting.serverId;
            this.orchardTitle = orchardHosting.orchardTitle;
            this.orchardImages = orchardHosting.orchardImages;
            this.orchardGardenCount = orchardHosting.orchardGardenCount;
            this.gardenCode = orchardHosting.gardenCode;
            this.orchardMoney = orchardHosting.orchardMoney;
            this.plantType = orchardHosting.plantType;
            this.orchardAddress = orchardHosting.orchardAddress;
            this.addressLonAndLat = orchardHosting.addressLonAndLat;
            this.hostingStartTime = orchardHosting.hostingStartTime;
            this.hostingEndTime = orchardHosting.hostingEndTime;
            this.hostingRequire = orchardHosting.hostingRequire;
            this.orchardIntroduce = orchardHosting.orchardIntroduce;
            this.hostingStatus = orchardHosting.hostingStatus;
            this.closeTime = orchardHosting.closeTime;
            this.orchardArea = orchardHosting.orchardArea;
            this.contractCode = orchardHosting.contractCode;
        }
    }
}
